/* Data file converter 1.0.26 to 1.1.0 */

/*-------------------------------------------------------------*/
/* includes used for this code                                 */
/*-------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>  
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h> 
#include <sys/time.h>      /* for linux users */

#include <arpa/telnet.h>
#include <netinet/in.h>

#include <fcntl.h>
#include <sys/file.h>
#include <netdb.h>
#include <dirent.h>
#include <signal.h>
#include <time.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/un.h>            /* linux users      */
#include <string.h>

/*------------------------------*/
/* START OF USER CONFIG SECTION */
/*------------------------------*/

/*-----------------------------------------------------------------*/
/* Change these 2 defines if you have increased or decreased your  */
/* max areas in you constants.h file from the default of 60        */
/*                                                                 */
/* Max areas defined in 1.0.26 version of code                     */

#define OLD_MAX_AREAS      60

/* Max areas defined in 1.1.0 version of code                      */

#define NEW_MAX_AREAS      60
/*                                                                 */
/*-----------------------------------------------------------------*/

/* Set these variables to whatever they're set at in the */
/* 1.0.26 constants.h                                    */
#define MAX_LINE_LEN   200
#define NAME_LEN       21
#define MACRO_LEN      70
#define DESC_LEN       41
#define EMAIL_LENGTH   80
#define HOME_LEN       66
#define NUM_LINES      15
#define NUM_ABBRS      16
#define MAX_GAG        15
#define MAX_ALERT      15
#define MAX_ENTERM     80
#define MAX_EXITM      45

/*----------------------------*/
/* END OF USER CONFIG SECTION */
/*----------------------------*/

#undef feof  /* otherwise feof func. wont compile */
#define LOOP_FOREVER while(1)
#define wbuf(buf) putbuf(f, buf)
#define wbufnocr(buf) fprintf (f, "%s ", (char *)buf)
#define wval(val) fprintf (f, "%d\n", val)
#define wlong(val) fprintf (f, "%d\n", val)
#define wtime(val) fprintf (f, "%d\n", val)
#define rbuf(buf) xread (f, (char *)buf, sizeof(buf))
#define rval(val) xread (f, (char *)&val, sizeof(val))
#define FCLOSE(file) if (file) fclose(file)

#define TRUE 1
#define FALSE 0
#define USERDIR "../users"
#define FILE_NAME_LEN  256
#define MAX_CHAR_BUFF  380
#define FLAG_OFFS "000000000000000000000000"
#define FLAG_ONS  "111111111111111111111111"
#define MAX_USERS      3000

char mess[9725];
char t_mess[9725];

int read_user();
int write_user();
int xwrite();
int xread();

/* abbreviation strucure */
typedef struct {
   char abbr[2];
   char com[20];
} Abbr;

/* user structure */
struct profile {
        char name[NAME_LEN];
        char password[NAME_LEN];  
        char desc[DESC_LEN]; /* user description */
        char email_addr[EMAIL_LENGTH];
        char sex[32];
        char site[21]; /* internet site number */
        char init_date[17];
        char init_site[21];
        char init_netname[64]; /* 1.1.0 */
        char last_date[17];
        char last_site[21];
        char dir[128];
        char entermsg[MAX_ENTERM];
        char exitmsg[MAX_EXITM+1];
        char succ[MAX_ENTERM];
        char fail[MAX_ENTERM];
        char homepage[HOME_LEN];
        char creation[25];
        char security[OLD_MAX_AREAS+1];
        char login_name[NAME_LEN];
        char login_pass[NAME_LEN];
        char phone_user[NAME_LEN];
        char mutter[NAME_LEN+6];
        char page_file[80];
         char *pro_start,*pro_end;
        int pro_enter;
         char *roomd_start,*roomd_end;
        int roomd_enter;   
         char *vote_start,*vote_end;
        int vote_enter;   
        int locked;
        int suspended;
        int area;
        int listen;
        int shout;
        int igtell;
        int color;
        int clrmail; /* User is clearing his mail file */
        int sock;  /* socket number */
        int monitor;
        int time;  /* length of time user has been on */
        int vis;   /* is user visible */
        int super;
        int invite;  /* area currently invited to */
        int last_input; /* this and warning are used for idle check */
        int warning_given;
        int logging_in;  /* user is logging in */
        int attleft;  /* no. of logging in attempts left */
        int file_posn;
        char net_name[64]; /* internet site name */
        char macros[20][MACRO_LEN+5];
        int  conv_count;
        char conv[NUM_LINES+1][MAX_LINE_LEN+1]; /* stores lines of conversation */
        int cat_mode;
        int rows;
        int cols;
        int car_return;
        int abbrs;
        int white_space;
        int line_count;
        int number_lines;
        int times_on;
        int afk;
        int lockafk;
        int upper;
        int lower;
        int aver;
        int totl;
        int autor;
        int autof;
        int automsgs; /* 1.0.26 */
        int gagcomm;  /* 1.0.26 */
        int semail;
        int quote;
        int hilite;
        int new_mail;   
        unsigned long numcoms;
        int mail_num;
        int numbering;
        char flags[25];
        char real_id[50];
        char attach_port;
        int  char_buffer_size;
        char char_buffer[MAX_CHAR_BUFF];
        int friend_num;
        int gag_num;
        int nerf_shots,nerf_energy;
        int nerf_kills,nerf_killed;
        int passhid;
        int pbreak;
        int pcount;
        int icount;
        int acount;     
        int pmode;
        char pinput[NAME_LEN];
        int rawtime;  
        int muz_time;  
        int xco_time;
        int gag_time;  /* 1.0.26 */
        int frog;      /* 1.0.26 */
        int frog_time; /* 1.0.26 */
        int promote;   /* 1.0.26 */
        int tzone;  
        char home_room[NAME_LEN];  
        char afkmsg[46];
        char last_name[64];        /* 1.0.26 */
        Abbr custAbbrs[NUM_ABBRS]; /* 1.0.26 */
        char say_name[NAME_LEN];   /* 1.0.26 */
        long new_totl;
        long new_numcoms;
        long new_rawtime;
        char new_security[NEW_MAX_AREAS+1];
        char new_init_date[25];
        char new_last_date[25];
        int beeps; /* 1.1.0 */
        };
struct profile ustr[MAX_USERS];        
struct profile t_ustr;


main()
{
int num;
int i=0;
int j=0;
char small_buff[64];
char tmpbuf1[30];
char tmpbuf2[30];
char filename[FILE_NAME_LEN];
char filerid[FILE_NAME_LEN];
time_t tm;
struct dirent *dp;
DIR  *dirp;
FILE *fp;

  puts(" ");
  puts("Will first backup user data files to  users.tar.gz");
  sprintf(mess,"tar cvf /tmp/users.tar %s/*",USERDIR);
  system(mess);
  strcpy(mess,"gzip -9 /tmp/users.tar");
  system(mess);
  strcpy(mess,"mv /tmp/users.tar.gz .");
  system(mess);
 
 sprintf(t_mess,"%s",USERDIR);
 strncpy(filerid,t_mess,FILE_NAME_LEN);

/* Reset new structures to 0 */ 
 num=0;

 dirp=opendir((char *)filerid);
  
 if (dirp == NULL)
   { printf("Directory information not found.\n");
    return;
   }
   
 while ((dp = readdir(dirp)) != NULL) 
   { 
    sprintf(small_buff,"%s",dp->d_name);
    if (small_buff[0]=='.') {
      small_buff[0]=0;
      continue;
      }

    read_user(small_buff);     /* Read user's profile */

/* Default values for new version go here */
if (t_ustr.rows == 0) t_ustr.rows=24;
if (t_ustr.cols == 0) t_ustr.cols=256;

t_ustr.new_totl    = t_ustr.totl;
t_ustr.new_numcoms = t_ustr.numcoms;
t_ustr.new_rawtime = t_ustr.rawtime;

t_ustr.beeps       = 0;

strcpy(t_ustr.say_name,t_ustr.name);
t_ustr.say_name[0]=toupper(t_ustr.say_name[0]);

strcpy(t_ustr.init_netname, t_ustr.last_name);

midcpy(t_ustr.init_date,tmpbuf1,0,16);
midcpy(t_ustr.last_date,tmpbuf2,0,16);
strcat(tmpbuf1,"00 1997");
strcat(tmpbuf2,"00 1997");
strcpy(t_ustr.new_init_date, tmpbuf1);
strcpy(t_ustr.new_last_date, tmpbuf2);


if (NEW_MAX_AREAS > OLD_MAX_AREAS) {
   i=NEW_MAX_AREAS-OLD_MAX_AREAS;

    for(j=OLD_MAX_AREAS;j<OLD_MAX_AREAS+i;++j)   
     {
      t_ustr.new_security[j]='N';
     }
 i=0;
 j=0;
 }

/* Defaults end here */
    write_user(small_buff);
    num++;

/* Set structures back to 0 just to be sure */
    printf("%d\n",num);
    small_buff[0]=0;
   }       /* End of while */
 
 printf("\n");
 sprintf(mess,"Converted %d users",num);
 printf("%s\n",mess);

 (void) closedir(dirp);

}

/*-----------------------------------------------------*/
/* Put a string with return to a file                  */
/*-----------------------------------------------------*/
putbuf(f, buf)
FILE *f;
char *buf;
{
fputs(buf,f);
fputs("\n",f);
}

/*----------------------------------------------------------------------*/
/* Read a buffer from a file.  If the read fails, we tell the user why  */
/* and return FALSE.                                                    */
/*----------------------------------------------------------------------*/

int xread (f, buf, size)
FILE *f;
char *buf;
int size;
{
	int bytes;

	bytes = fread (buf, 1, size, f);
	if (bytes == -1) {
		return (FALSE);
	}
	if (bytes != size) {
		return (FALSE);
	}
	return (TRUE);
}


/*----------------------------------------------------------------------*/
/* read the user profile                                                */
/*----------------------------------------------------------------------*/

int read_user(name)
char * name;
{
FILE *f;                 /* user file*/
char filename[FILE_NAME_LEN];

sprintf(t_mess,"%s/%s",USERDIR,name);
strncpy(filename,t_mess,FILE_NAME_LEN);

f = fopen (filename, "r"); /* open for output */
if (f == NULL)
  {
    return(0);
  }
  
/*--------------------------------------------------------*/
/* values added after initial release must be initialized */
/*--------------------------------------------------------*/
t_ustr.monitor       = 0;
t_ustr.rows          = 24;
t_ustr.cols          = 256;
t_ustr.car_return    = 0;
t_ustr.abbrs         = 1;
t_ustr.white_space   = 1;
t_ustr.times_on      = 1;
t_ustr.aver          = 0;
t_ustr.totl          = 0;
t_ustr.autor         = 0;
t_ustr.autof         = 0;
t_ustr.automsgs      = 0;
t_ustr.gagcomm       = 0;
t_ustr.semail        = 0;
t_ustr.quote         = 0;
t_ustr.hilite        = 0;
t_ustr.new_mail      = 0;
t_ustr.color         = 0;
t_ustr.numcoms       = 0;
t_ustr.mail_num      = 0;
t_ustr.friend_num    = 0;
t_ustr.gag_num       = 0;
t_ustr.rawtime       = 0;
t_ustr.nerf_kills    = 0;
t_ustr.nerf_killed   = 0;
t_ustr.passhid       = 0;
t_ustr.pbreak        = 0;
t_ustr.muz_time      = 0;
t_ustr.xco_time      = 0;
t_ustr.gag_time      = 0;
t_ustr.frog          = 0;
t_ustr.frog_time     = 0;
t_ustr.promote       = 0;
t_ustr.tzone         = 0;
t_ustr.super         = 0;
strcpy(t_ustr.flags, FLAG_OFFS);

rbuf(t_ustr.name);
rbuf(t_ustr.password);
rval(t_ustr.super);
rbuf(t_ustr.email_addr);
rbuf(t_ustr.desc);
rbuf(t_ustr.sex);
rbuf(t_ustr.init_date);
rbuf(t_ustr.last_date);
rbuf(t_ustr.init_site);
rbuf(t_ustr.last_site);   /* last site */
rbuf(t_ustr.last_name);   /* last hostname */
rbuf(t_ustr.say_name);
rbuf(t_ustr.custAbbrs);
rbuf(t_ustr.dir);
rval(t_ustr.area);
rval(t_ustr.listen);
rval(t_ustr.shout);
rval(t_ustr.vis);
rval(t_ustr.locked);
rval(t_ustr.suspended);
rbuf(t_ustr.security);
rbuf(t_ustr.entermsg);
rbuf(t_ustr.exitmsg);
rbuf(t_ustr.home_room);
rbuf(t_ustr.fail);
rbuf(t_ustr.succ);
rbuf(t_ustr.homepage);
rbuf(t_ustr.creation);
rval(t_ustr.monitor);
rval(t_ustr.rows);
rval(t_ustr.cols);
rval(t_ustr.car_return);
rval(t_ustr.abbrs);
rval(t_ustr.times_on);
rval(t_ustr.white_space);
rval(t_ustr.aver);
rval(t_ustr.totl);
rval(t_ustr.autor);
rval(t_ustr.autof);
rval(t_ustr.automsgs);
rval(t_ustr.gagcomm);
rval(t_ustr.semail);
rval(t_ustr.quote);
rval(t_ustr.hilite);
rval(t_ustr.new_mail);
rval(t_ustr.color);
rval(t_ustr.passhid);
rval(t_ustr.pbreak);
rval(t_ustr.numcoms);
rval(t_ustr.mail_num);
rval(t_ustr.friend_num);
rval(t_ustr.gag_num);
rval(t_ustr.nerf_kills);
rval(t_ustr.nerf_killed);
rval(t_ustr.muz_time);
rval(t_ustr.xco_time);
rval(t_ustr.gag_time);
rval(t_ustr.frog);
rval(t_ustr.frog_time);
rval(t_ustr.promote);
rval(t_ustr.tzone);
rval(t_ustr.rawtime);
rbuf(t_ustr.flags);

FCLOSE(f);
return(1);

}


/*----------------------------------------------------------------------*/
/* write a user temp buffer to a users data file                        */
/*----------------------------------------------------------------------*/
write_user(name)
char *name;
{
int i=0;
FILE *f;                 /* user file*/
char filename[FILE_NAME_LEN];

sprintf(t_mess,"%s/%s",USERDIR,name);
strncpy(filename,t_mess,FILE_NAME_LEN);

f = fopen (filename, "w"); /* open for output */

if (f==NULL)
  { return; }
  
wbuf(t_ustr.name);        /* users name */
wbuf(t_ustr.say_name);    /* users properly capitalized name */
wbuf(t_ustr.password);    /* users excrypted password */
wval(t_ustr.super);       /* users level or rank */
wbuf(t_ustr.email_addr);  /* users email address */
wbuf(t_ustr.desc);        /* users description */
wbuf(t_ustr.sex);         /* users gender */
wbuf(t_ustr.new_init_date);   /* users original login time */
wbuf(t_ustr.new_last_date);   /* users last login time */
wbuf(t_ustr.init_site);   /* users original site */
wbuf(t_ustr.last_site);   /* users last site */
wbuf(t_ustr.last_name);   /* users last hostname */
wbuf(t_ustr.init_netname);   /* users original hostname */

for (i=0;i<NUM_ABBRS;++i) {
 if (i<NUM_ABBRS-1) {
   wbufnocr(t_ustr.custAbbrs[i].abbr);
   wbufnocr(t_ustr.custAbbrs[i].com);
  }
 else if (i==NUM_ABBRS-1) {
   wbufnocr(t_ustr.custAbbrs[i].abbr);
   wbuf(t_ustr.custAbbrs[i].com);
  }
}
i=0;

/*----------------------------------------*/
/*  users last area in and will login to  */
/*  users muzzled or not                  */
/*  users visible or not                  */
/*  users locked or not                   */
/*  users xcommed or not                  */
/*----------------------------------------*/
fprintf(f, "%d %d %d %d %d\n", t_ustr.area, t_ustr.shout,
           t_ustr.vis, t_ustr.locked, t_ustr.suspended);

wbuf(t_ustr.entermsg);    /* users room enter message */
wbuf(t_ustr.exitmsg);     /* users room exit message */
wbuf(t_ustr.home_room);   /* users home room */
wbuf(t_ustr.fail);        /* users fail message */
wbuf(t_ustr.succ);        /* users success message */
wbuf(t_ustr.homepage);    /* users homepage */
wbuf(t_ustr.creation);    /* users creation date */
if (NEW_MAX_AREAS > OLD_MAX_AREAS)
 wbuf(t_ustr.new_security);    /* users room permissions */
else 
 wbuf(t_ustr.security);    /* users room permissions */
wbuf(t_ustr.flags);       /* users listening and ignoring flags */
wlong(t_ustr.numcoms);    /* users number of commands done */
wlong(t_ustr.totl);       /* users total minutes online */
wtime(t_ustr.rawtime);    /* users last login in time_t format */

/* Read rest of values, too many to document here */
fprintf(f, "%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",
          t_ustr.monitor, t_ustr.rows, t_ustr.cols, t_ustr.car_return,
          t_ustr.abbrs, t_ustr.times_on, t_ustr.white_space, t_ustr.aver,
          t_ustr.autor, t_ustr.autof, t_ustr.automsgs,
          t_ustr.gagcomm, t_ustr.semail, t_ustr.quote, t_ustr.hilite,
          t_ustr.new_mail, t_ustr.color, t_ustr.passhid);

fprintf(f, "%d %d %d %d %d %d %d %d %d %d %d %d %d\n",
          t_ustr.pbreak, t_ustr.mail_num, t_ustr.friend_num, t_ustr.gag_num,
          t_ustr.nerf_kills, t_ustr.nerf_killed, t_ustr.muz_time,
          t_ustr.xco_time, t_ustr.gag_time, t_ustr.frog, t_ustr.frog_time,
          t_ustr.promote, t_ustr.beeps);

FCLOSE(f);
return;

}

midcpy(strf,strt,fr,to)
char *strf,*strt;
int fr,to;
{
int f;
for (f=fr;f<=to;++f)
  {
   if (!strf[f])
     {
      strt[f-fr]='\0';
      return;
     }
   strt[f-fr]=strf[f];
  }
strt[f-fr]='\0';
}

